/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.event;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.event.NodeEvent;
import org.apache.nifi.reporting.Severity;

public class Event
implements NodeEvent {
    private final String source;
    private final long timestamp;
    private final Severity severity;
    private final String message;

    public Event(String source, String message) {
        this(source, message, Severity.INFO);
    }

    public Event(String source, String message, Severity severity) {
        this(source, message, severity, new Date().getTime());
    }

    public Event(String source, String message, long timestamp) {
        this(source, message, Severity.INFO, timestamp);
    }

    public Event(String source, String message, Severity severity, long timestamp) {
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new IllegalArgumentException("Source may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Event message may not be empty or null.");
        }
        if (severity == null) {
            throw new IllegalArgumentException("Event category may not be null.");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp may not be negative: " + timestamp);
        }
        this.source = source;
        this.message = message;
        this.severity = severity;
        this.timestamp = timestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

