/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterProviderMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class ParameterProviderEndpointMerger
extends AbstractSingleEntityEndpoint<ParameterProviderEntity>
implements EndpointResponseMerger {
    public static final Pattern PARAMETER_PROVIDER_URI_PATTERN = Pattern.compile("/nifi-api/parameter-providers/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && PARAMETER_PROVIDER_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ParameterProviderEntity> getEntityClass() {
        return ParameterProviderEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterProviderEntity clientEntity, Map<NodeIdentifier, ParameterProviderEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        for (ParameterProviderEntity entity : entityMap.values()) {
            ParameterProviderMerger.merge(clientEntity, entity);
        }
    }
}

