/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PortsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.InputPortsEntity;
import org.apache.nifi.web.api.entity.PortEntity;

public class InputPortsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern INPUT_PORTS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/input-ports");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && INPUT_PORTS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        InputPortsEntity responseEntity = (InputPortsEntity)clientResponse.getClientResponse().readEntity(InputPortsEntity.class);
        Set portEntities = responseEntity.getInputPorts();
        HashMap<String, Map<NodeIdentifier, PortEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            InputPortsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (InputPortsEntity)nodeResponse.getClientResponse().readEntity(InputPortsEntity.class);
            Set nodePortEntities = nodeResponseEntity.getInputPorts();
            for (PortEntity nodePortEntity : nodePortEntities) {
                Map innerMap = entityMap.computeIfAbsent(nodePortEntity.getId(), k -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodePortEntity);
            }
        }
        PortsEntityMerger.mergePorts(portEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

