/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.io.Serializable;
import java.util.Arrays;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.DataFlowAdapter;

@XmlJavaTypeAdapter(value=DataFlowAdapter.class)
public class StandardDataFlow
implements Serializable,
DataFlow {
    private final byte[] flow;
    private final byte[] templateBytes;
    private final byte[] snippetBytes;
    private boolean autoStartProcessors;

    public StandardDataFlow(byte[] flow, byte[] templateBytes, byte[] snippetBytes) {
        if (flow == null) {
            throw new NullPointerException("Flow cannot be null");
        }
        this.flow = flow;
        this.templateBytes = templateBytes;
        this.snippetBytes = snippetBytes;
    }

    public StandardDataFlow(DataFlow toCopy) {
        this.flow = StandardDataFlow.copy(toCopy.getFlow());
        this.templateBytes = StandardDataFlow.copy(toCopy.getTemplates());
        this.snippetBytes = StandardDataFlow.copy(toCopy.getSnippets());
        this.autoStartProcessors = toCopy.isAutoStartProcessors();
    }

    private static byte[] copy(byte[] bytes) {
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] getFlow() {
        return this.flow;
    }

    public byte[] getTemplates() {
        return this.templateBytes;
    }

    public byte[] getSnippets() {
        return this.snippetBytes;
    }

    public boolean isAutoStartProcessors() {
        return this.autoStartProcessors;
    }

    public void setAutoStartProcessors(boolean autoStartProcessors) {
        this.autoStartProcessors = autoStartProcessors;
    }
}

