/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.reduce;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;
import org.apache.nifi.expression.AttributeExpression;

public class CountEvaluator
extends WholeNumberEvaluator
implements ReduceEvaluator<Long> {
    private final Evaluator<?> subjectEvaluator;
    private long count = 0L;

    public CountEvaluator(Evaluator<?> subjectEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(attributes);
        if (result.getValue() == null) {
            return new WholeNumberQueryResult(this.count);
        }
        if (result.getResultType() == AttributeExpression.ResultType.BOOLEAN && ((Boolean)result.getValue()).equals(Boolean.FALSE)) {
            return new WholeNumberQueryResult(this.count);
        }
        ++this.count;
        return new WholeNumberQueryResult(this.count);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

