/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class OrEvaluator
extends BooleanEvaluator {
    private final Evaluator<Boolean> subjectEvaluator;
    private final Evaluator<Boolean> rhsEvaluator;
    private BooleanQueryResult rhsResult;

    public OrEvaluator(Evaluator<Boolean> subjectEvaluator, Evaluator<Boolean> rhsEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
        this.rhsEvaluator = rhsEvaluator;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        QueryResult<Boolean> subjectValue = this.subjectEvaluator.evaluate(attributes);
        if (subjectValue == null) {
            return new BooleanQueryResult(null);
        }
        if (Boolean.TRUE.equals(subjectValue.getValue())) {
            return new BooleanQueryResult(true);
        }
        if (this.rhsResult != null) {
            return this.rhsResult;
        }
        QueryResult<Boolean> rhsValue = this.rhsEvaluator.evaluate(attributes);
        this.rhsResult = rhsValue == null ? new BooleanQueryResult(false) : new BooleanQueryResult(rhsValue.getValue());
        return this.rhsResult;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

