/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class CharSequenceTranslatorEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final CharSequenceTranslator method;

    public static StringEvaluator jsonEscapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.ESCAPE_JSON);
    }

    public static StringEvaluator xmlEscapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.ESCAPE_XML10);
    }

    public static StringEvaluator csvEscapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.ESCAPE_CSV);
    }

    public static StringEvaluator html3EscapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.ESCAPE_HTML3);
    }

    public static StringEvaluator html4EscapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.ESCAPE_HTML4);
    }

    public static StringEvaluator jsonUnescapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.UNESCAPE_JSON);
    }

    public static StringEvaluator xmlUnescapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.UNESCAPE_XML);
    }

    public static StringEvaluator csvUnescapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.UNESCAPE_CSV);
    }

    public static StringEvaluator html3UnescapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.UNESCAPE_HTML3);
    }

    public static StringEvaluator html4UnescapeEvaluator(Evaluator<String> subject) {
        return new CharSequenceTranslatorEvaluator(subject, StringEscapeUtils.UNESCAPE_HTML4);
    }

    public CharSequenceTranslatorEvaluator(Evaluator<String> subject, CharSequenceTranslator method) {
        this.subject = subject;
        this.method = method;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        return new StringQueryResult(subjectValue == null ? "" : this.method.translate((CharSequence)subjectValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

