/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class ReplaceAllEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;
    private final Evaluator<String> replacement;

    public ReplaceAllEvaluator(Evaluator<String> subject, Evaluator<String> search, Evaluator<String> replacement) {
        this.subject = subject;
        this.search = search;
        this.replacement = replacement;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String searchValue = this.search.evaluate(attributes).getValue();
        String replacementValue = this.replacement.evaluate(attributes).getValue();
        return new StringQueryResult(subjectValue.replaceAll(searchValue, replacementValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

