/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class PrependEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> prependEvaluator;

    public PrependEvaluator(Evaluator<String> subject, Evaluator<String> prepend) {
        this.subject = subject;
        this.prependEvaluator = prepend;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        String prependValue = this.prependEvaluator.evaluate(attributes).getValue();
        String result = (prependValue == null ? "" : prependValue) + (subjectValue == null ? "" : subjectValue);
        return new StringQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

