/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class MultiplyEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> multiplyValue;

    public MultiplyEvaluator(Evaluator<Number> subject, Evaluator<Number> multiplyValue) {
        this.subject = subject;
        this.multiplyValue = multiplyValue;
    }

    @Override
    public QueryResult<Number> evaluate(Map<String, String> attributes) {
        Number subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Number multiply = this.multiplyValue.evaluate(attributes).getValue();
        if (multiply == null) {
            return new NumberQueryResult(null);
        }
        Number result = subjectValue instanceof Double || multiply instanceof Double ? (Number)(subjectValue.doubleValue() * multiply.doubleValue()) : (Number)(subjectValue.longValue() * multiply.longValue());
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

