/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;

public class FromRadixEvaluator
extends WholeNumberEvaluator {
    private final Evaluator<String> numberEvaluator;
    private final Evaluator<Long> radixEvaluator;

    public FromRadixEvaluator(Evaluator<String> subject, Evaluator<Long> radixEvaluator) {
        this.numberEvaluator = subject;
        this.radixEvaluator = radixEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        String result = this.numberEvaluator.evaluate(attributes).getValue();
        if (result == null) {
            return new WholeNumberQueryResult(null);
        }
        Long radix = this.radixEvaluator.evaluate(attributes).getValue();
        if (radix == null) {
            return new WholeNumberQueryResult(null);
        }
        long longValue = Long.parseLong(result, radix.intValue());
        return new WholeNumberQueryResult(longValue);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.numberEvaluator;
    }
}

