/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.ValueLookup;
import org.apache.nifi.attribute.expression.language.evaluation.EvaluatorState;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;

public class StandardEvaluationContext
implements EvaluationContext {
    private final ValueLookup valueLookup;
    private final Map<String, String> stateMap;
    private final ParameterLookup parameterLookup;
    private final EvaluatorState evaluatorState = new EvaluatorState();

    public StandardEvaluationContext(Map<String, String> variables) {
        this(variables, null, ParameterLookup.EMPTY);
    }

    public StandardEvaluationContext(Map<String, String> variables, Map<String, String> stateMap, ParameterLookup parameterLookup) {
        this(new ValueLookup(VariableRegistry.ENVIRONMENT_SYSTEM_REGISTRY, null, variables), stateMap, parameterLookup);
    }

    public StandardEvaluationContext(ValueLookup valueLookup, Map<String, String> stateMap, ParameterLookup parameterLookup) {
        this.valueLookup = valueLookup;
        this.stateMap = stateMap;
        this.parameterLookup = parameterLookup;
    }

    @Override
    public String getExpressionValue(String name) {
        return this.valueLookup.get(name);
    }

    @Override
    public Set<String> getExpressionKeys() {
        return this.valueLookup.getKeysAddressableByMultiMatch();
    }

    @Override
    public String getState(String key) {
        return this.stateMap.get(key);
    }

    @Override
    public Parameter getParameter(String parameterName) {
        return this.parameterLookup.getParameter(parameterName).orElse(null);
    }

    @Override
    public EvaluatorState getEvaluatorState() {
        return this.evaluatorState;
    }
}

