/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lineage;

import java.util.List;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.lineage.LineageNodeType;
import org.apache.nifi.provenance.lineage.ProvenanceEventLineageNode;

public class EventNode
implements ProvenanceEventLineageNode {
    private final ProvenanceEventRecord record;
    private String clusterNodeIdentifier = null;

    public EventNode(ProvenanceEventRecord event) {
        this.record = event;
    }

    public String getIdentifier() {
        return String.valueOf(this.getEventIdentifier());
    }

    public LineageNodeType getNodeType() {
        return LineageNodeType.PROVENANCE_EVENT_NODE;
    }

    public ProvenanceEventType getEventType() {
        return this.record.getEventType();
    }

    public long getTimestamp() {
        return this.record.getEventTime();
    }

    public long getEventIdentifier() {
        return this.record.getEventId();
    }

    public String getFlowFileUuid() {
        return this.record.getFlowFileUuid();
    }

    public List<String> getParentUuids() {
        return this.record.getParentUuids();
    }

    public List<String> getChildUuids() {
        return this.record.getChildUuids();
    }

    public int hashCode() {
        return 2938472 + this.record.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventNode)) {
            return false;
        }
        EventNode other = (EventNode)obj;
        return this.record.equals((Object)other.record);
    }

    public String toString() {
        return "Event[ID=" + this.record.getEventId() + ", Type=" + String.valueOf(this.record.getEventType()) + ", UUID=" + this.record.getFlowFileUuid() + ", Component=" + this.record.getComponentId() + "]";
    }
}

