/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyManagementException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.provenance.EncryptionException;
import org.apache.nifi.provenance.EncryptionMetadata;
import org.apache.nifi.provenance.ProvenanceEventEncryptor;
import org.apache.nifi.security.kms.CryptoUtils;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.AESKeyedCipherProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESProvenanceEventEncryptor
implements ProvenanceEventEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(AESProvenanceEventEncryptor.class);
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int IV_LENGTH = 16;
    private static final byte[] EMPTY_IV = new byte[16];
    private static final String VERSION = "v1";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("v1");
    private static final int MIN_METADATA_LENGTH = 22;
    private static final int METADATA_DEFAULT_LENGTH = (20 + "AES/GCM/NoPadding".length() + 16 + "v1".length()) * 2;
    private static final byte[] SENTINEL = new byte[]{1};
    private KeyProvider keyProvider;
    private AESKeyedCipherProvider aesKeyedCipherProvider = new AESKeyedCipherProvider();

    @Override
    public void initialize(KeyProvider keyProvider) throws KeyManagementException {
        this.keyProvider = keyProvider;
        if (this.aesKeyedCipherProvider == null) {
            this.aesKeyedCipherProvider = new AESKeyedCipherProvider();
        }
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    void setCipherProvider(AESKeyedCipherProvider cipherProvider) {
        this.aesKeyedCipherProvider = cipherProvider;
    }

    @Override
    public byte[] encrypt(byte[] plainRecord, String recordId, String keyId) throws EncryptionException {
        if (plainRecord == null || CryptoUtils.isEmpty((String)keyId)) {
            throw new EncryptionException("The provenance record and key ID cannot be missing");
        }
        if (this.keyProvider == null || !this.keyProvider.keyExists(keyId)) {
            throw new EncryptionException("The requested key ID is not available");
        }
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        try {
            logger.debug("Encrypting provenance record " + recordId + " with key ID " + keyId);
            Cipher cipher = this.initCipher(EncryptionMethod.AES_GCM, 1, this.keyProvider.getKey(keyId), ivBytes);
            ivBytes = cipher.getIV();
            byte[] cipherBytes = cipher.doFinal(plainRecord);
            EncryptionMetadata metadata = new EncryptionMetadata(keyId, ALGORITHM, ivBytes, VERSION, cipherBytes.length);
            byte[] serializedEncryptionMetadata = this.serializeEncryptionMetadata(metadata);
            logger.debug("Encrypted provenance event record " + recordId + " with key ID " + keyId);
            return CryptoUtils.concatByteArrays((byte[][])new byte[][]{SENTINEL, serializedEncryptionMetadata, cipherBytes});
        }
        catch (IOException | KeyManagementException | BadPaddingException | IllegalBlockSizeException | EncryptionException e) {
            String msg = "Encountered an exception encrypting provenance record " + recordId;
            logger.error(msg, e);
            throw new EncryptionException(msg, e);
        }
    }

    private byte[] serializeEncryptionMetadata(EncryptionMetadata metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(baos);
        outputStream.writeObject(metadata);
        outputStream.close();
        return baos.toByteArray();
    }

    private Cipher initCipher(EncryptionMethod method, int mode, SecretKey key, byte[] ivBytes) throws EncryptionException {
        try {
            if (method == null || key == null || ivBytes == null) {
                throw new IllegalArgumentException("Missing critical information");
            }
            return this.aesKeyedCipherProvider.getCipher(method, key, ivBytes, mode == 1);
        }
        catch (Exception e) {
            logger.error("Encountered an exception initializing the cipher", (Throwable)e);
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] decrypt(byte[] encryptedRecord, String recordId) throws EncryptionException {
        EncryptionMetadata metadata;
        if (encryptedRecord == null) {
            throw new EncryptionException("The encrypted provenance record cannot be missing");
        }
        try {
            metadata = this.extractEncryptionMetadata(encryptedRecord);
        }
        catch (IOException | ClassNotFoundException e) {
            String msg = "Encountered an error reading the encryption metadata: ";
            logger.error("Encountered an error reading the encryption metadata: ", (Throwable)e);
            throw new EncryptionException("Encountered an error reading the encryption metadata: ", e);
        }
        if (!SUPPORTED_VERSIONS.contains(metadata.version)) {
            throw new EncryptionException("The event was encrypted with version " + metadata.version + " which is not in the list of supported versions " + StringUtils.join(SUPPORTED_VERSIONS, (String)","));
        }
        if (this.keyProvider == null || !this.keyProvider.keyExists(metadata.keyId) || CryptoUtils.isEmpty((String)metadata.keyId)) {
            throw new EncryptionException("The requested key ID " + metadata.keyId + " is not available");
        }
        try {
            logger.debug("Decrypting provenance record " + recordId + " with key ID " + metadata.keyId);
            EncryptionMethod method = EncryptionMethod.forAlgorithm((String)metadata.algorithm);
            Cipher cipher = this.initCipher(method, 2, this.keyProvider.getKey(metadata.keyId), metadata.ivBytes);
            byte[] cipherBytes = this.extractCipherBytes(encryptedRecord, metadata);
            byte[] plainBytes = cipher.doFinal(cipherBytes);
            logger.debug("Decrypted provenance event record " + recordId + " with key ID " + metadata.keyId);
            return plainBytes;
        }
        catch (KeyManagementException | BadPaddingException | IllegalBlockSizeException | EncryptionException e) {
            String msg = "Encountered an exception decrypting provenance record " + recordId;
            logger.error(msg, e);
            throw new EncryptionException(msg, e);
        }
    }

    @Override
    public String getNextKeyId() throws KeyManagementException {
        List availableKeyIds;
        if (this.keyProvider != null && !(availableKeyIds = this.keyProvider.getAvailableKeyIds()).isEmpty()) {
            return (String)availableKeyIds.get(0);
        }
        throw new KeyManagementException("No available key IDs");
    }

    private EncryptionMetadata extractEncryptionMetadata(byte[] encryptedRecord) throws EncryptionException, IOException, ClassNotFoundException {
        if (encryptedRecord == null || encryptedRecord.length < 22) {
            throw new EncryptionException("The encrypted record is too short to contain the metadata");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(encryptedRecord);
        bais.read();
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            EncryptionMetadata encryptionMetadata = (EncryptionMetadata)ois.readObject();
            return encryptionMetadata;
        }
    }

    private byte[] extractCipherBytes(byte[] encryptedRecord, EncryptionMetadata metadata) {
        return Arrays.copyOfRange(encryptedRecord, encryptedRecord.length - metadata.cipherByteLength, encryptedRecord.length);
    }

    public String toString() {
        return "AES Provenance Event Encryptor with Key Provider: " + this.keyProvider.toString();
    }
}

