/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.Objects;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.provenance.search.SearchableFieldType;

public class NamedSearchableField
implements SearchableField {
    private final String identifier;
    private final String searchableName;
    private final SearchableFieldType fieldType;
    private final String friendlyName;
    private final boolean attribute;
    private final int hash;

    NamedSearchableField(String identifier, String searchableName, String friendlyName, boolean attribute) {
        this(identifier, searchableName, friendlyName, attribute, SearchableFieldType.STRING);
    }

    NamedSearchableField(String identifier, String searchableName, String friendlyName, boolean attribute, SearchableFieldType fieldType) {
        this.identifier = Objects.requireNonNull(identifier);
        this.searchableName = Objects.requireNonNull(searchableName);
        this.friendlyName = Objects.requireNonNull(friendlyName);
        this.attribute = Objects.requireNonNull(attribute);
        this.fieldType = Objects.requireNonNull(fieldType);
        this.hash = 298347 + searchableName.hashCode() + (attribute ? 1 : 0);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getSearchableFieldName() {
        return this.searchableName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public SearchableFieldType getFieldType() {
        return this.fieldType;
    }

    public String toString() {
        return this.friendlyName;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableField)) {
            return false;
        }
        SearchableField other = (SearchableField)obj;
        return this.attribute == other.isAttribute() && this.searchableName.equals(other.getSearchableFieldName());
    }
}

