/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;

@XmlType(name="parameter")
public class ParameterDTO {
    private String name;
    private String description;
    private Boolean sensitive;
    private String value;
    private Boolean valueRemoved;
    private Set<AffectedComponentEntity> referencingComponents;
    private ParameterContextReferenceEntity parameterContext;
    private Boolean inherited;

    @ApiModelProperty(value="The name of the Parameter")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Whether or not the Parameter is inherited from another context", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Boolean getInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }

    @ApiModelProperty(value="The description of the Parameter")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="Whether or not the Parameter is sensitive")
    public Boolean getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    @ApiModelProperty(value="The value of the Parameter")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(value="Whether or not the value of the Parameter was removed. When a request is made to change a parameter, the value may be null. The absence of the value may be used either to indicate that the value is not to be changed, or that the value is to be set to null (i.e., removed). This denotes which of the two scenarios is being encountered.")
    public Boolean getValueRemoved() {
        return this.valueRemoved;
    }

    public void setValueRemoved(Boolean valueRemoved) {
        this.valueRemoved = valueRemoved;
    }

    @ApiModelProperty(value="The set of all components in the flow that are referencing this Parameter")
    public Set<AffectedComponentEntity> getReferencingComponents() {
        return this.referencingComponents;
    }

    public void setParameterContext(ParameterContextReferenceEntity parameterContext) {
        this.parameterContext = parameterContext;
    }

    @ApiModelProperty(value="A reference to the Parameter Context that contains this one")
    public ParameterContextReferenceEntity getParameterContext() {
        return this.parameterContext;
    }

    public void setReferencingComponents(Set<AffectedComponentEntity> referencingComponents) {
        this.referencingComponents = referencingComponents;
    }

    public String toString() {
        return "ParameterDTO[name=" + this.name + ", sensitive=" + this.sensitive + ", value=" + (this.sensitive != false ? "********" : this.value) + "]";
    }
}

