/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.nifi.flow.ConnectableComponentType;

public class ConnectableComponent {
    private String id;
    private String instanceId;
    private ConnectableComponentType type;
    private String groupId;
    private String name;
    private String comments;

    @ApiModelProperty(value="The id of the connectable component.", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The instance ID of an existing component that is described by this VersionedComponent, or null if this is not mapped to an instantiated component")
    public String getInstanceIdentifier() {
        return this.instanceId;
    }

    public void setInstanceIdentifier(String instanceIdentifier) {
        this.instanceId = instanceIdentifier;
    }

    @ApiModelProperty(value="The type of component the connectable is.", required=true)
    public ConnectableComponentType getType() {
        return this.type;
    }

    public void setType(ConnectableComponentType type) {
        this.type = type;
    }

    @ApiModelProperty(value="The id of the group that the connectable component resides in", required=true)
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The name of the connectable component")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The comments for the connectable component.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.groupId, this.name, this.type, this.comments});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectableComponent)) {
            return false;
        }
        ConnectableComponent other = (ConnectableComponent)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "ConnectableComponent{id='" + this.id + "', instanceId='" + this.instanceId + "', type=" + String.valueOf((Object)this.type) + ", groupId='" + this.groupId + "', name='" + this.name + "'}";
    }
}

