/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.xml.XmlSaxDataContext;
import org.apache.metamodel.xml.XmlSaxTableDef;

public class XmlSaxDataContextFactory
implements DataContextFactory {
    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        boolean hasTableDefs = properties.getTableDefs() != null || properties.toMap().containsKey("xml-sax-table-defs");
        return "xml".equals(properties.getDataContextType()) && hasTableDefs;
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        SimpleTableDef[] simpleTableDefs = properties.getTableDefs();
        List<XmlSaxTableDef> tableDefs = simpleTableDefs == null ? this.createTableDefFromProperties(properties.toMap().get("xml-sax-table-defs")) : Arrays.stream(simpleTableDefs).map(tableDef -> new XmlSaxTableDef(tableDef.getName(), tableDef.getColumnNames())).collect(Collectors.toList());
        Resource resource = resourceFactoryRegistry.createResource(properties.getResourceProperties());
        return new XmlSaxDataContext(resource, tableDefs);
    }

    private List<XmlSaxTableDef> createTableDefFromProperties(Object configuredTableDefs) {
        ArrayList<XmlSaxTableDef> tableDefs = new ArrayList<XmlSaxTableDef>();
        if (configuredTableDefs instanceof List) {
            List list = (List)configuredTableDefs;
            list.forEach(tableDef -> {
                String rowXpath = (String)tableDef.get("row-x-path");
                Collection valueXpaths = (Collection)tableDef.get("value-x-paths");
                tableDefs.add(new XmlSaxTableDef(rowXpath, valueXpaths));
            });
        } else if (configuredTableDefs instanceof Map) {
            Map map = (Map)configuredTableDefs;
            map.forEach((k, v) -> {
                String rowXpath = k;
                Collection valueXpaths = v;
                tableDefs.add(new XmlSaxTableDef(rowXpath, valueXpaths));
            });
        } else {
            throw new IllegalArgumentException("Unsupported value type for property 'xml-sax-table-defs'. Map or List expected, but got: " + configuredTableDefs);
        }
        return tableDefs;
    }
}

