/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.salesforce;

import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.metamodel.salesforce.SalesforceTable;
import org.apache.metamodel.salesforce.SalesforceUtils;
import org.apache.metamodel.schema.AbstractSchema;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LazyRef;

final class SalesforceSchema
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final transient Supplier<List<Table>> _tableRef;
    private final transient PartnerConnection _connection;

    public SalesforceSchema(String name, PartnerConnection connection) {
        this._name = name;
        this._connection = connection;
        this._tableRef = new LazyRef<List<Table>>(){

            protected List<Table> fetch() {
                DescribeGlobalResult describeGlobal;
                ArrayList<Table> result = new ArrayList<Table>();
                try {
                    describeGlobal = SalesforceSchema.this._connection.describeGlobal();
                }
                catch (ConnectionException e) {
                    throw SalesforceUtils.wrapException(e, "Failed to invoke describeGlobal service");
                }
                for (DescribeGlobalSObjectResult sobject : describeGlobal.getSobjects()) {
                    if (!sobject.isQueryable() || !sobject.isUpdateable()) continue;
                    String tableName = sobject.getName();
                    String tableLabel = sobject.getLabel();
                    SalesforceTable table = new SalesforceTable(tableName, tableLabel, (Schema)SalesforceSchema.this, SalesforceSchema.this._connection);
                    result.add((Table)table);
                }
                return result;
            }
        };
    }

    public String getName() {
        return this._name;
    }

    public List<Table> getTables() {
        return Collections.unmodifiableList(this._tableRef.get());
    }

    public String getQuote() {
        return null;
    }
}

