/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.neo4j.ColumnTypeResolver;
import org.apache.metamodel.neo4j.Neo4jCypherQueryBuilder;
import org.apache.metamodel.neo4j.Neo4jDataSet;
import org.apache.metamodel.neo4j.Neo4jRequestWrapper;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.util.SimpleTableDef;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jDataContext
extends QueryPostprocessDataContext
implements DataContext,
DocumentSourceProvider {
    public static final String SCHEMA_NAME = "neo4j";
    public static final int DEFAULT_PORT = 7474;
    static final String NEO4J_KEY_METADATA = "metadata";
    static final String NEO4J_KEY_METADATA_TYPE = "type";
    static final String NEO4J_KEY_PROPERTIES = "properties";
    static final String NEO4J_KEY_DATA = "data";
    static final String NEO4J_KEY_ID = "id";
    static final String NEO4J_KEY_RESPONSE_RESULTS = "results";
    static final String NEO4J_KEY_RESPONSE_ROW = "row";
    static final String NEO4J_COLUMN_NAME_ID = "_id";
    static final String NEO4J_COLUMN_NAME_RELATION_PREFIX = "rel_";
    static final String NEO4J_COLUMN_NAME_RELATION_LIST_INDICATOR = "#";
    private static final Logger logger = LoggerFactory.getLogger(Neo4jDataContext.class);
    private final SimpleTableDef[] _tableDefs;
    private final Neo4jRequestWrapper _requestWrapper;
    private final HttpHost _httpHost;
    private String _serviceRoot = "/db/data";

    public Neo4jDataContext(String hostname, int port, String username, String password, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = tableDefs;
    }

    public Neo4jDataContext(String hostname, int port, String username, String password, String serviceRoot, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = tableDefs;
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, String username, String password) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
    }

    public Neo4jDataContext(String hostname, int port, String username, String password, String serviceRoot) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, username, password, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, String serviceRoot) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = this.detectTableDefs();
        this._serviceRoot = serviceRoot;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = tableDefs;
    }

    public Neo4jDataContext(String hostname, int port, CloseableHttpClient httpClient, String serviceRoot, SimpleTableDef ... tableDefs) {
        super(false);
        this._httpHost = new HttpHost(hostname, port);
        this._requestWrapper = new Neo4jRequestWrapper(httpClient, this._httpHost, this._serviceRoot);
        this._tableDefs = tableDefs;
        this._serviceRoot = serviceRoot;
    }

    protected String getDefaultSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this._tableDefs) {
            MutableTable table = tableDef.toTable().setSchema((Schema)schema);
            schema.addTable((Table)table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    public SimpleTableDef[] detectTableDefs() {
        ArrayList<SimpleTableDef> tableDefs = new ArrayList<SimpleTableDef>();
        String labelsJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/labels"));
        try {
            JSONArray labelsJsonArray = new JSONArray(labelsJsonString);
            for (int i = 0; i < labelsJsonArray.length(); ++i) {
                SimpleTableDef tableDefFromLabel = this.createTableDefFromLabel(labelsJsonArray.getString(i));
                if (tableDefFromLabel == null) continue;
                tableDefs.add(tableDefFromLabel);
            }
            return tableDefs.toArray(new SimpleTableDef[tableDefs.size()]);
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON while detecting the schema: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private SimpleTableDef createTableDefFromLabel(String label) throws JSONException {
        List<JSONObject> nodesPerLabel = this.getAllNodesPerLabel(label);
        List<String> propertiesPerLabel = this.getPropertiesFromLabelNodes(nodesPerLabel);
        LinkedHashSet<String> relationshipPropertiesPerLabel = new LinkedHashSet<String>();
        for (JSONObject node : nodesPerLabel) {
            Integer nodeId = (Integer)node.getJSONObject(NEO4J_KEY_METADATA).get(NEO4J_KEY_ID);
            Set<String> relationshipPropertiesForNode = this.createRelationshipPropertiesForNode(nodeId);
            relationshipPropertiesPerLabel.addAll(relationshipPropertiesForNode);
        }
        propertiesPerLabel.addAll(relationshipPropertiesPerLabel);
        if (nodesPerLabel.isEmpty()) {
            return null;
        }
        String[] columnNames = propertiesPerLabel.toArray(new String[propertiesPerLabel.size()]);
        ColumnTypeResolver columnTypeResolver = new ColumnTypeResolver(nodesPerLabel.get(0), columnNames);
        return new SimpleTableDef(label, columnNames, columnTypeResolver.getColumnTypes());
    }

    private Set<String> createRelationshipPropertiesForNode(Integer nodeId) throws JSONException {
        List<JSONObject> relationshipsPerNode = this.getOutgoingRelationshipsPerNode(nodeId);
        LinkedHashSet<String> relationshipProperties = new LinkedHashSet<String>();
        for (JSONObject relationship : relationshipsPerNode) {
            String relationshipName = relationship.getString(NEO4J_KEY_METADATA_TYPE);
            String relationshipNameProperty = NEO4J_COLUMN_NAME_RELATION_PREFIX + relationshipName;
            relationshipProperties.add(relationshipNameProperty);
            List<String> propertiesPerRelationship = this.getAllPropertiesPerRelationship(relationship);
            relationshipProperties.addAll(propertiesPerRelationship);
        }
        return relationshipProperties;
    }

    private List<String> getPropertiesFromLabelNodes(List<JSONObject> nodesPerLabel) {
        ArrayList<String> propertiesPerLabel = new ArrayList<String>();
        for (JSONObject node : nodesPerLabel) {
            List<String> propertiesPerNode = this.getAllPropertiesPerNode(node);
            for (String property : propertiesPerNode) {
                if (propertiesPerLabel.contains(property)) continue;
                propertiesPerLabel.add(property);
            }
        }
        return propertiesPerLabel;
    }

    private List<String> getAllPropertiesPerRelationship(JSONObject relationship) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        try {
            String relationshipName = NEO4J_COLUMN_NAME_RELATION_PREFIX + relationship.getJSONObject(NEO4J_KEY_METADATA).getString(NEO4J_KEY_METADATA_TYPE);
            JSONObject relationshipPropertiesJSONObject = relationship.getJSONObject(NEO4J_KEY_DATA);
            if (relationshipPropertiesJSONObject.length() > 0) {
                JSONArray relationshipPropertiesNamesJSONArray = relationshipPropertiesJSONObject.names();
                for (int i = 0; i < relationshipPropertiesNamesJSONArray.length(); ++i) {
                    String propertyName = relationshipName + NEO4J_COLUMN_NAME_RELATION_LIST_INDICATOR + relationshipPropertiesNamesJSONArray.getString(i);
                    if (propertyNames.contains(propertyName)) continue;
                    propertyNames.add(propertyName);
                }
            }
            return propertyNames;
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON while getting relationship properties: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<JSONObject> getOutgoingRelationshipsPerNode(Integer nodeId) {
        ArrayList<JSONObject> outgoingRelationshipsPerNode = new ArrayList<JSONObject>();
        String outgoingRelationshipsPerNodeJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/node/" + nodeId + "/relationships/out"));
        try {
            JSONArray outgoingRelationshipsPerNodeJsonArray = new JSONArray(outgoingRelationshipsPerNodeJsonString);
            for (int i = 0; i < outgoingRelationshipsPerNodeJsonArray.length(); ++i) {
                JSONObject relationship = outgoingRelationshipsPerNodeJsonArray.getJSONObject(i);
                if (outgoingRelationshipsPerNode.contains(relationship)) continue;
                outgoingRelationshipsPerNode.add(relationship);
            }
            return outgoingRelationshipsPerNode;
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON while detecting outgoing relationships for node: " + nodeId, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<JSONObject> getAllNodesPerLabel(String label) {
        ArrayList<JSONObject> allNodesPerLabel = new ArrayList<JSONObject>();
        String allNodesForLabelJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(this._serviceRoot + "/label/" + label + "/nodes"));
        try {
            JSONArray allNodesForLabelJsonArray = new JSONArray(allNodesForLabelJsonString);
            for (int i = 0; i < allNodesForLabelJsonArray.length(); ++i) {
                JSONObject node = allNodesForLabelJsonArray.getJSONObject(i);
                allNodesPerLabel.add(node);
            }
            return allNodesPerLabel;
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON while detecting the nodes for a label: " + label, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private List<String> getAllPropertiesPerNode(JSONObject node) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(NEO4J_COLUMN_NAME_ID);
        try {
            String propertiesEndpoint = node.getString(NEO4J_KEY_PROPERTIES);
            String allPropertiesPerNodeJsonString = this._requestWrapper.executeRestRequest((HttpRequestBase)new HttpGet(propertiesEndpoint));
            JSONObject allPropertiesPerNodeJsonObject = new JSONObject(allPropertiesPerNodeJsonString);
            for (int j = 0; j < allPropertiesPerNodeJsonObject.length(); ++j) {
                JSONArray propertiesJsonArray = allPropertiesPerNodeJsonObject.names();
                for (int k = 0; k < propertiesJsonArray.length(); ++k) {
                    String property = propertiesJsonArray.getString(k);
                    properties.add(property);
                }
            }
            return properties;
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON while detecting the properties of a node: " + node, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int firstRow, int maxRows) {
        if (columns != null && columns.size() > 0) {
            Neo4jDataSet dataSet;
            try {
                String selectQuery = Neo4jCypherQueryBuilder.buildSelectQuery(table, columns, firstRow, maxRows);
                String responseJSONString = this._requestWrapper.executeCypherQuery(selectQuery);
                JSONObject resultJSONObject = new JSONObject(responseJSONString);
                List<SelectItem> selectItems = columns.stream().map(SelectItem::new).collect(Collectors.toList());
                dataSet = new Neo4jDataSet(selectItems, resultJSONObject);
            }
            catch (JSONException e) {
                logger.error("Error occurred in parsing JSON while materializing the schema: ", (Throwable)e);
                throw new IllegalStateException(e);
            }
            return dataSet;
        }
        logger.error("Encountered null or empty columns array for materializing main schema table.");
        throw new IllegalArgumentException("Columns cannot be null or empty array");
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        return this.materializeMainSchemaTable(table, columns, 1, maxRows);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        String countQuery = Neo4jCypherQueryBuilder.buildCountQuery(table.getName(), whereItems);
        String jsonResponse = this._requestWrapper.executeCypherQuery(countQuery);
        try {
            JSONObject jsonResponseObject = new JSONObject(jsonResponse);
            JSONArray resultsJSONArray = jsonResponseObject.getJSONArray(NEO4J_KEY_RESPONSE_RESULTS);
            JSONObject resultJSONObject = (JSONObject)resultsJSONArray.get(0);
            JSONArray dataJSONArray = resultJSONObject.getJSONArray(NEO4J_KEY_DATA);
            JSONObject rowJSONObject = (JSONObject)dataJSONArray.get(0);
            JSONArray valueJSONArray = rowJSONObject.getJSONArray(NEO4J_KEY_RESPONSE_ROW);
            Number value = (Number)valueJSONArray.get(0);
            return value;
        }
        catch (JSONException e) {
            logger.error("Error occurred in parsing JSON response: ", (Throwable)e);
            return null;
        }
    }

    public DocumentSource getMixedDocumentSourceForSampling() {
        return null;
    }

    public DocumentSource getDocumentSourceForTable(String sourceCollectionName) {
        return null;
    }
}

