/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

public class Neo4jCypherQueryBuilder {
    public static String buildSelectQuery(Table table, List<Column> columns, int firstRow, int maxRows) {
        List<String> columnNames = columns.stream().map(col -> col.getName()).collect(Collectors.toList());
        return Neo4jCypherQueryBuilder.buildSelectQuery(table.getName(), columnNames, firstRow, maxRows);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSelectQuery(String tableName, List<String> columnNames, int firstRow, int maxRows) {
        LinkedHashMap<String, String> returnClauseMap = new LinkedHashMap<String, String>();
        LinkedHashMap<void, Integer> relationshipIndexMap = new LinkedHashMap<void, Integer>();
        for (String string : columnNames) {
            if (string.startsWith("rel_")) {
                String relationshipAlias;
                void var8_13;
                String relationshipPropertyName;
                String string2 = string.replace("rel_", "");
                if (string2.contains("#")) {
                    String[] parsedColumnNameArray = string2.split("#");
                    String string3 = parsedColumnNameArray[0];
                    relationshipPropertyName = parsedColumnNameArray[1];
                } else {
                    String string4 = string2;
                    relationshipPropertyName = "metamodel_neo4j_relationship_marker";
                }
                if (relationshipIndexMap.containsKey(var8_13)) {
                    relationshipAlias = "r" + relationshipIndexMap.get(var8_13);
                } else {
                    int nextIndex = relationshipIndexMap.values().isEmpty() ? 0 : (Integer)Collections.max(relationshipIndexMap.values()) + 1;
                    relationshipIndexMap.put(var8_13, nextIndex);
                    relationshipAlias = "r" + relationshipIndexMap.get(var8_13);
                }
                if (relationshipPropertyName.equals("metamodel_neo4j_relationship_marker")) {
                    returnClauseMap.put(string2, "id(" + relationshipAlias + "_relationshipEndNode)");
                    continue;
                }
                returnClauseMap.put(string2, relationshipAlias + "." + relationshipPropertyName);
                continue;
            }
            if (string.equals("_id")) {
                returnClauseMap.put(string, "id(n)");
                continue;
            }
            returnClauseMap.put(string, "n." + string);
        }
        StringBuilder cypherBuilder = new StringBuilder();
        cypherBuilder.append("MATCH (n:");
        cypherBuilder.append(tableName);
        for (Map.Entry entry : relationshipIndexMap.entrySet()) {
            cypherBuilder.append(") OPTIONAL MATCH (n)-[r" + entry.getValue() + ":" + (String)entry.getKey() + "]->(r" + entry.getValue() + "_relationshipEndNode");
        }
        cypherBuilder.append(") RETURN ");
        boolean bl = false;
        for (Map.Entry returnClauseEntry : returnClauseMap.entrySet()) {
            boolean bl2;
            if (bl2) {
                cypherBuilder.append(",");
            }
            cypherBuilder.append((String)returnClauseEntry.getValue());
            bl2 = true;
        }
        if (firstRow > 1) {
            cypherBuilder.append(" SKIP " + (firstRow - 1));
        }
        if (maxRows > -1) {
            cypherBuilder.append(" LIMIT " + maxRows);
        }
        return cypherBuilder.toString();
    }

    public static String buildCountQuery(String tableName, List<FilterItem> whereItems) {
        StringBuilder cypherBuilder = new StringBuilder();
        cypherBuilder.append("MATCH (n:");
        cypherBuilder.append(tableName);
        cypherBuilder.append(") ");
        cypherBuilder.append(Neo4jCypherQueryBuilder.buildWhereClause(whereItems, "n"));
        cypherBuilder.append(" RETURN COUNT(*);");
        return cypherBuilder.toString();
    }

    private static String buildWhereClause(List<FilterItem> whereItems, String queryObjectHandle) {
        if (whereItems != null && !whereItems.isEmpty()) {
            StringBuilder whereClauseBuilder = new StringBuilder();
            whereClauseBuilder.append("WHERE ");
            FilterItem firstWhereItem = whereItems.get(0);
            whereClauseBuilder.append(Neo4jCypherQueryBuilder.buildWhereClauseItem(firstWhereItem, queryObjectHandle));
            for (int i = 1; i < whereItems.size(); ++i) {
                whereClauseBuilder.append(" AND ");
                FilterItem whereItem = whereItems.get(i);
                whereClauseBuilder.append(Neo4jCypherQueryBuilder.buildWhereClauseItem(whereItem, queryObjectHandle));
            }
            return whereClauseBuilder.toString();
        }
        return "";
    }

    private static String buildWhereClauseItem(FilterItem whereItem, String queryObjectHandle) {
        StringBuilder whereClauseItemBuilder = new StringBuilder();
        whereClauseItemBuilder.append(queryObjectHandle);
        whereClauseItemBuilder.append(".");
        whereClauseItemBuilder.append(whereItem.getSelectItem().getColumn().getName());
        whereClauseItemBuilder.append(whereItem.getOperator().toSql());
        Object operand = whereItem.getOperand();
        if (operand instanceof String) {
            whereClauseItemBuilder.append("\"");
        }
        whereClauseItemBuilder.append(operand);
        if (operand instanceof String) {
            whereClauseItemBuilder.append("\"");
        }
        return whereClauseItemBuilder.toString();
    }
}

