/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jRequestWrapper.class);
    private final CloseableHttpClient _httpClient;
    private final HttpHost _httpHost;
    private final HttpPost _cypherQueryHttpPost;
    private final String _username;
    private final String _password;

    public Neo4jRequestWrapper(CloseableHttpClient httpClient, HttpHost httpHost, String username, String password, String serviceRoot) {
        this._httpClient = httpClient;
        this._httpHost = httpHost;
        this._username = username;
        this._password = password;
        this._cypherQueryHttpPost = new HttpPost(serviceRoot + "/transaction/commit");
    }

    public Neo4jRequestWrapper(CloseableHttpClient httpClient, HttpHost httpHost, String serviceRoot) {
        this(httpClient, httpHost, null, null, serviceRoot);
    }

    public String executeRestRequest(HttpRequestBase httpRequest) {
        return this.executeRestRequest(httpRequest, this._username, this._password);
    }

    public String executeRestRequest(HttpRequestBase httpRequest, String username, String password) {
        if (username != null && password != null) {
            String base64credentials = BaseEncoding.base64().encode((username + ":" + password).getBytes(StandardCharsets.UTF_8));
            httpRequest.addHeader("Authorization", "Basic " + base64credentials);
        }
        try {
            CloseableHttpResponse response = this._httpClient.execute(this._httpHost, (HttpRequest)httpRequest);
            if (response.getEntity() != null) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            return null;
        }
        catch (ClientProtocolException e) {
            logger.error("An error occured while executing " + httpRequest, (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            logger.error("An error occured while executing " + httpRequest, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public String executeCypherQuery(String cypherQuery) {
        JSONObject cypherQueryRequest = new JSONObject();
        HashMap<String, String> statement = new HashMap<String, String>();
        statement.put("statement", cypherQuery);
        JSONArray statementsArray = new JSONArray();
        statementsArray.put(statement);
        return this.executeRequest(cypherQueryRequest, statementsArray);
    }

    public String executeCypherQueries(List<String> cypherQueries) {
        JSONObject cypherQueryRequest = new JSONObject();
        JSONArray statementsArray = new JSONArray();
        for (String cypherQuery : cypherQueries) {
            HashMap<String, String> statement = new HashMap<String, String>();
            statement.put("statement", cypherQuery);
            statementsArray.put(statement);
        }
        return this.executeRequest(cypherQueryRequest, statementsArray);
    }

    private String executeRequest(JSONObject cypherQueryRequest, JSONArray statementsArray) {
        try {
            cypherQueryRequest.put("statements", (Object)statementsArray);
            String requestBody = cypherQueryRequest.toString();
            this._cypherQueryHttpPost.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
            String responseJSONString = this.executeRestRequest((HttpRequestBase)this._cypherQueryHttpPost);
            return responseJSONString;
        }
        catch (JSONException e) {
            logger.error("Error occured while constructing JSON request body for " + this._cypherQueryHttpPost, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

