/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb;

import com.mongodb.DBCollection;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.mongodb.MongoDbDataContext;
import org.apache.metamodel.mongodb.MongoDbDeleteBuilder;
import org.apache.metamodel.mongodb.MongoDbDropTableBuilder;
import org.apache.metamodel.mongodb.MongoDbInsertionBuilder;
import org.apache.metamodel.mongodb.MongoDbTableCreationBuilder;
import org.apache.metamodel.mongodb.WriteConcernAdvisor;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class MongoDbUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback,
Closeable {
    private final MongoDbDataContext _dataContext;
    private final Map<String, DBCollection> _collections;
    private final WriteConcernAdvisor _writeConcernAdvisor;

    public MongoDbUpdateCallback(MongoDbDataContext dataContext, WriteConcernAdvisor writeConcernAdvisor) {
        super((DataContext)dataContext);
        this._dataContext = dataContext;
        this._writeConcernAdvisor = writeConcernAdvisor;
        this._collections = new HashMap<String, DBCollection>();
    }

    public MongoDbDataContext getDataContext() {
        return this._dataContext;
    }

    public WriteConcernAdvisor getWriteConcernAdvisor() {
        return this._writeConcernAdvisor;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new MongoDbTableCreationBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new MongoDbInsertionBuilder(this, table);
    }

    protected void createCollection(String name) {
        DBCollection collection = this._dataContext.getMongoDb().createCollection(name, null);
        this._collections.put(name, collection);
    }

    protected void removeCollection(String name) {
        DBCollection collection = this.getCollection(name);
        this._collections.remove(name);
        collection.drop();
    }

    protected DBCollection getCollection(String name) {
        DBCollection collection = this._collections.get(name);
        if (collection == null) {
            collection = this._dataContext.getMongoDb().getCollection(name);
            this._collections.put(name, collection);
        }
        return collection;
    }

    @Override
    public void close() {
        this._collections.clear();
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws UnsupportedOperationException {
        return new MongoDbDropTableBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new MongoDbDeleteBuilder(this, table);
    }
}

