/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo3;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.mongodb.mongo3.MongoDbDataContext;
import org.apache.metamodel.mongodb.mongo3.MongoDbUpdateCallback;
import org.apache.metamodel.schema.Table;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDeleteBuilder.class);
    private final MongoDbUpdateCallback _updateCallback;

    public MongoDbDeleteBuilder(MongoDbUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        MongoCollection<Document> collection = this._updateCallback.getCollection(this.getTable().getName());
        MongoDbDataContext dataContext = this._updateCallback.getDataContext();
        Document query = dataContext.createMongoDbQuery(this.getTable(), this.getWhereItems(), whereItem -> {
            throw new UnsupportedOperationException("Unable to handle WHERE item in DELETE: " + whereItem.toSql());
        });
        DeleteResult result = collection.deleteMany((Bson)query);
        logger.info("Remove returned result: {}", (Object)result);
    }
}

