/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo3;

import com.mongodb.client.MongoCursor;
import java.util.Map;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.mongodb.common.MongoDBUtils;
import org.apache.metamodel.schema.Column;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final MongoCursor<Document> _cursor;
    private final boolean _queryPostProcessed;
    private boolean _closed;
    private volatile Document _document;

    public MongoDbDataSet(MongoCursor<Document> cursor, Column[] columns, boolean queryPostProcessed) {
        super(columns);
        this._cursor = cursor;
        this._queryPostProcessed = queryPostProcessed;
        this._closed = false;
    }

    public boolean isQueryPostProcessed() {
        return this._queryPostProcessed;
    }

    public void close() {
        super.close();
        this._cursor.close();
        this._closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        if (this._cursor.hasNext()) {
            this._document = (Document)this._cursor.next();
            return true;
        }
        this._document = null;
        return false;
    }

    public Row getRow() {
        return MongoDBUtils.toRow((Map)this._document, (DataSetHeader)this.getHeader());
    }
}

