/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo2;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.mongodb.mongo2.MongoDbUpdateCallback;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbInsertionBuilder
extends AbstractRowInsertionBuilder<MongoDbUpdateCallback>
implements RowInsertionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbInsertionBuilder.class);

    public MongoDbInsertionBuilder(MongoDbUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        BasicDBObject doc = new BasicDBObject();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            doc.put(columns[i].getName(), value);
        }
        MongoDbUpdateCallback updateCallback = (MongoDbUpdateCallback)this.getUpdateCallback();
        DBCollection collection = updateCallback.getCollection(this.getTable().getName());
        WriteConcern writeConcern = updateCallback.getWriteConcernAdvisor().adviceInsert(collection, doc);
        WriteResult writeResult = collection.insert((DBObject)doc, writeConcern);
        logger.info("Insert returned result: {}", (Object)writeResult);
    }
}

