/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.mongo2;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.mongodb.mongo2.MongoDbDataContext;
import org.apache.metamodel.mongodb.mongo2.MongoDbUpdateCallback;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDeleteBuilder.class);
    private final MongoDbUpdateCallback _updateCallback;

    public MongoDbDeleteBuilder(MongoDbUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        DBCollection collection = this._updateCallback.getCollection(this.getTable().getName());
        MongoDbDataContext dataContext = this._updateCallback.getDataContext();
        BasicDBObject query = dataContext.createMongoDbQuery(this.getTable(), this.getWhereItems());
        WriteConcern writeConcern = this._updateCallback.getWriteConcernAdvisor().adviceDeleteQuery(collection, query);
        WriteResult writeResult = collection.remove((DBObject)query, writeConcern);
        logger.info("Remove returned result: {}", (Object)writeResult);
    }
}

