/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.mongodb.common;

import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.CollectionUtils;

public class MongoDBUtils {
    public static Row toRow(DBObject dbObject, DataSetHeader header) {
        if (dbObject == null) {
            return null;
        }
        Map map = dbObject.toMap();
        return MongoDBUtils.toRow(map, header);
    }

    public static Row toRow(Map<?, ?> map, DataSetHeader header) {
        if (map == null) {
            return null;
        }
        int size = header.size();
        Object[] values = new Object[size];
        for (int i = 0; i < values.length; ++i) {
            SelectItem selectItem = header.getSelectItem(i);
            String key = selectItem.getColumn().getName();
            Object value = CollectionUtils.find(map, (String)key);
            values[i] = MongoDBUtils.toValue(selectItem.getColumn(), value);
        }
        return new DefaultRow(header, values);
    }

    private static Object toValue(Column column, Object value) {
        if (value instanceof List) {
            return value;
        }
        if (value instanceof DBObject) {
            DBObject basicDBObject = (DBObject)value;
            return basicDBObject.toMap();
        }
        return value;
    }
}

