/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.util.List;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FilterClause;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromClause;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.GroupByClause;
import org.apache.metamodel.query.GroupByItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.OrderByClause;
import org.apache.metamodel.query.OrderByItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.ScalarFunction;
import org.apache.metamodel.query.SelectClause;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryRewriter
implements IQueryRewriter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcDataContext _dataContext;

    public AbstractQueryRewriter(JdbcDataContext dataContext) {
        this._dataContext = dataContext;
    }

    public JdbcDataContext getDataContext() {
        return this._dataContext;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ColumnType getColumnType(int jdbcType, String nativeType, Integer columnSize) {
        return ColumnTypeImpl.convertColumnType((int)jdbcType);
    }

    @Override
    public String rewriteQuery(Query query) {
        query = this.beforeRewrite(query);
        StringBuilder sb = new StringBuilder();
        sb.append(this.rewriteSelectClause(query, query.getSelectClause()));
        sb.append(this.rewriteFromClause(query, query.getFromClause()));
        sb.append(this.rewriteWhereClause(query, query.getWhereClause()));
        sb.append(this.rewriteGroupByClause(query, query.getGroupByClause()));
        sb.append(this.rewriteHavingClause(query, query.getHavingClause()));
        sb.append(this.rewriteOrderByClause(query, query.getOrderByClause()));
        return sb.toString();
    }

    public boolean isSchemaIncludedInColumnPaths() {
        return false;
    }

    protected Query beforeRewrite(Query query) {
        return query;
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        return this.rewriteColumnTypeInternal(columnType.toString(), columnSize);
    }

    protected String rewriteColumnTypeInternal(String columnType, Object columnParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(columnType);
        if (columnParameter != null) {
            sb.append('(');
            sb.append(columnParameter);
            sb.append(')');
        }
        return sb.toString();
    }

    protected String rewriteOrderByClause(Query query, OrderByClause orderByClause) {
        StringBuilder sb = new StringBuilder();
        if (orderByClause.getItemCount() > 0) {
            sb.append(" ORDER BY ");
            List items = orderByClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                OrderByItem item = (OrderByItem)items.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.rewriteOrderByItem(query, item));
            }
        }
        return sb.toString();
    }

    @Override
    public String rewriteFromItem(FromItem item) {
        return this.rewriteFromItem(item.getQuery(), item);
    }

    protected String rewriteOrderByItem(Query query, OrderByItem item) {
        return item.toSql(this.isSchemaIncludedInColumnPaths());
    }

    protected String rewriteHavingClause(Query query, FilterClause havingClause) {
        StringBuilder sb = new StringBuilder();
        if (havingClause.getItemCount() > 0) {
            sb.append(" HAVING ");
            List items = havingClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                FilterItem item = (FilterItem)items.get(i);
                if (i != 0) {
                    sb.append(" AND ");
                }
                sb.append(this.rewriteFilterItem(item));
            }
        }
        return sb.toString();
    }

    protected String rewriteGroupByClause(Query query, GroupByClause groupByClause) {
        StringBuilder sb = new StringBuilder();
        if (groupByClause.getItemCount() > 0) {
            sb.append(" GROUP BY ");
            List items = groupByClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                GroupByItem item = (GroupByItem)items.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.rewriteGroupByItem(query, item));
            }
        }
        return sb.toString();
    }

    protected String rewriteGroupByItem(Query query, GroupByItem item) {
        return item.toSql(this.isSchemaIncludedInColumnPaths());
    }

    protected String rewriteWhereClause(Query query, FilterClause whereClause) {
        StringBuilder sb = new StringBuilder();
        if (whereClause.getItemCount() > 0) {
            sb.append(" WHERE ");
            List items = whereClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                FilterItem item = (FilterItem)items.get(i);
                if (i != 0) {
                    sb.append(" AND ");
                }
                sb.append(this.rewriteFilterItem(item));
            }
        }
        return sb.toString();
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        Object operand;
        if (item.isCompoundFilter()) {
            FilterItem[] childItems = item.getChildItems();
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (int i = 0; i < childItems.length; ++i) {
                FilterItem child = childItems[i];
                if (i != 0) {
                    sb.append(' ');
                    sb.append(item.getLogicalOperator().toString());
                    sb.append(' ');
                }
                sb.append(this.rewriteFilterItem(child));
            }
            sb.append(')');
            return sb.toString();
        }
        String primaryFilterSql = item.toSql(this.isSchemaIncludedInColumnPaths());
        OperatorType operator = item.getOperator();
        if (OperatorType.DIFFERENT_FROM.equals(operator) && (operand = item.getOperand()) != null) {
            FilterItem isNullFilter = new FilterItem(item.getSelectItem(), OperatorType.EQUALS_TO, null);
            String secondaryFilterSql = this.rewriteFilterItem(isNullFilter);
            return '(' + primaryFilterSql + " OR " + secondaryFilterSql + ')';
        }
        return primaryFilterSql;
    }

    protected String rewriteFromClause(Query query, FromClause fromClause) {
        StringBuilder sb = new StringBuilder();
        if (fromClause.getItemCount() > 0) {
            sb.append(" FROM ");
            List items = fromClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                FromItem item = (FromItem)items.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.rewriteFromItem(query, item));
            }
        }
        return sb.toString();
    }

    protected String rewriteFromItem(Query query, FromItem item) {
        return item.toSql(this.isSchemaIncludedInColumnPaths());
    }

    protected String rewriteSelectClause(Query query, SelectClause selectClause) {
        StringBuilder sb = new StringBuilder();
        if (selectClause.getItemCount() > 0) {
            sb.append("SELECT ");
            if (selectClause.isDistinct()) {
                sb.append("DISTINCT ");
            }
            List items = selectClause.getItems();
            for (int i = 0; i < items.size(); ++i) {
                ScalarFunction scalarFunction;
                SelectItem item = (SelectItem)items.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                if ((scalarFunction = item.getScalarFunction()) != null && !this.isScalarFunctionSupported(scalarFunction)) {
                    item = item.replaceFunction(null);
                }
                sb.append(this.rewriteSelectItem(query, item));
            }
        }
        return sb.toString();
    }

    protected String rewriteSelectItem(Query query, SelectItem item) {
        if (item.isFunctionApproximationAllowed()) {
            item = item.replaceFunctionApproximationAllowed(false);
        }
        return item.toSql(this.isSchemaIncludedInColumnPaths());
    }
}

