/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.io.ObjectStreamException;
import java.util.List;
import org.apache.metamodel.jdbc.JdbcSchema;
import org.apache.metamodel.jdbc.MetadataLoader;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.TableType;

final class JdbcTable
extends MutableTable {
    private static final long serialVersionUID = 5952310469458880330L;
    private final transient MetadataLoader _metadataLoader;

    public JdbcTable(String name, TableType type, JdbcSchema schema, MetadataLoader metadataLoader) {
        super(name, type, (Schema)schema);
        this._metadataLoader = metadataLoader;
    }

    protected List<Column> getColumnsInternal() {
        if (this._metadataLoader != null) {
            this._metadataLoader.loadColumns(this);
        }
        return super.getColumnsInternal();
    }

    protected List<Relationship> getRelationshipsInternal() {
        Schema schema = this.getSchema();
        if (schema instanceof JdbcSchema) {
            ((JdbcSchema)schema).loadRelations();
        }
        return super.getRelationshipsInternal();
    }

    protected void loadIndexes() {
        if (this._metadataLoader != null) {
            this._metadataLoader.loadIndexes(this);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.getColumns();
        this.loadIndexes();
        this.loadPrimaryKeys();
        return this;
    }

    public void loadPrimaryKeys() {
        if (this._metadataLoader != null) {
            this._metadataLoader.loadPrimaryKeys(this);
        }
    }
}

