/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcBatchUpdateCallback
extends JdbcUpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(JdbcBatchUpdateCallback.class);

    public JdbcBatchUpdateCallback(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    protected void closePreparedStatement(PreparedStatement preparedStatement) {
        try {
            int[] results = preparedStatement.executeBatch();
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < results.length; ++i) {
                    String resultString;
                    int result = results[i];
                    switch (result) {
                        case -2: {
                            resultString = "SUCCESS_NO_INFO";
                            break;
                        }
                        case -3: {
                            resultString = "EXECUTE_FAILED";
                            break;
                        }
                        default: {
                            resultString = result + " rows updated";
                        }
                    }
                    logger.debug("batch execute result[" + i + "]:" + resultString);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute batch: " + preparedStatement);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{preparedStatement});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{preparedStatement});
    }

    @Override
    protected void executePreparedStatement(PreparedStatement st) throws SQLException {
        st.addBatch();
    }
}

