/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.metamodel.drop.AbstractTableDropBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.jdbc.JdbcSchema;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class JdbcDropTableBuilder
extends AbstractTableDropBuilder
implements TableDropBuilder {
    private final JdbcUpdateCallback _updateCallback;
    private final IQueryRewriter _queryRewriter;

    public JdbcDropTableBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter) {
        super(table);
        this._updateCallback = updateCallback;
        this._queryRewriter = queryRewriter;
    }

    public void execute() {
        String sql = this.createSqlStatement();
        PreparedStatement statement = this._updateCallback.getPreparedStatement(sql, false);
        try {
            this._updateCallback.executePreparedStatement(statement, false);
            Schema schema = this.getTable().getSchema();
            if (schema instanceof JdbcSchema) {
                ((JdbcSchema)schema).refreshTables();
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "execute drop table statement: " + sql);
        }
    }

    protected String createSqlStatement() {
        FromItem fromItem = new FromItem(this.getTable());
        String tableLabel = this._queryRewriter.rewriteFromItem(fromItem);
        return "DROP TABLE " + tableLabel;
    }
}

