/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

class HBaseRowDeletionBuilder
extends AbstractRowDeletionBuilder {
    private final HBaseDataContext _dataContext;

    public HBaseRowDeletionBuilder(HBaseDataContext dataContext, Table table) {
        super(table);
        if (dataContext == null) {
            throw new IllegalArgumentException("DataContext cannot be null");
        }
        this._dataContext = dataContext;
    }

    public synchronized void execute() {
        List whereItems = this.getWhereItems();
        if (whereItems == null || whereItems.size() == 0) {
            throw new IllegalArgumentException("HBase currently only supports deleting items by their row key.");
        }
        FilterItem filterItem = (FilterItem)whereItems.get(0);
        if (!"_id".equals(filterItem.getSelectItem().getColumn().getName())) {
            throw new IllegalArgumentException("HBase currently only supports deleting items by their row key.");
        }
        this.getRowKeys(filterItem).forEach(rowKey -> this._dataContext.getHBaseClient().deleteRow(this.getTable().getName(), rowKey));
    }

    private List<Object> getRowKeys(FilterItem whereItem) {
        ArrayList<Object> rowKeys = new ArrayList<Object>();
        if (whereItem.isCompoundFilter()) {
            LogicalOperator logicalOperator = whereItem.getLogicalOperator();
            if (logicalOperator != LogicalOperator.OR) {
                throw new IllegalStateException("HBase currently only supports deleting items by their row key. Violated by operator between where items: " + whereItem);
            }
            Arrays.stream(whereItem.getChildItems()).forEach(childItem -> rowKeys.addAll(this.getRowKeys((FilterItem)childItem)));
        } else {
            OperatorType operator = whereItem.getOperator();
            if (!OperatorType.EQUALS_TO.equals(operator) && !OperatorType.IN.equals(operator)) {
                throw new IllegalStateException("HBase currently only supports deleting items by their row key. Violated by operator in where item: " + whereItem);
            }
            SelectItem selectItem = whereItem.getSelectItem();
            Column column = selectItem.getColumn();
            Object operand = whereItem.getOperand();
            if (column == null || operand == null || !column.isPrimaryKey() || selectItem.hasFunction()) {
                throw new IllegalStateException("HBase currently only supports deleting items by their row key. Violated by where item: " + whereItem);
            }
            rowKeys.add(operand);
        }
        return rowKeys;
    }
}

