/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.metamodel.data.AbstractRow;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.hbase.HBaseFamilyMap;
import org.apache.metamodel.schema.Column;

final class HBaseRow
extends AbstractRow
implements Row {
    private static final long serialVersionUID = 1L;
    private final DataSetHeader _header;
    private final Result _result;

    public HBaseRow(DataSetHeader header, Result result) {
        this._header = header;
        this._result = result;
    }

    protected DataSetHeader getHeader() {
        return this._header;
    }

    public Object getValue(int index) throws IndexOutOfBoundsException {
        Column column = this._header.getSelectItem(index).getColumn();
        String name = column.getName();
        if ("_id".equals(name)) {
            byte[] rowKey = this._result.getRow();
            if (column.getType().isLiteral()) {
                return Bytes.toString((byte[])rowKey);
            }
            return rowKey;
        }
        int colonIndex = name.indexOf(58);
        if (colonIndex != -1) {
            byte[] qualifier;
            byte[] family = name.substring(0, colonIndex).getBytes();
            byte[] value = this._result.getValue(family, qualifier = name.substring(colonIndex + 1).getBytes());
            if (value == null) {
                return null;
            }
            if (column.getType().isLiteral()) {
                return Bytes.toString((byte[])value);
            }
            return value;
        }
        NavigableMap map = this._result.getFamilyMap(name.getBytes());
        if (map == null || map.isEmpty()) {
            return map;
        }
        return new HBaseFamilyMap(map);
    }

    public Style getStyle(int index) throws IndexOutOfBoundsException {
        return Style.NO_STYLE;
    }
}

