/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.Serializable;
import java.util.List;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.BaseObject;
import org.apache.metamodel.util.SimpleTableDef;

public class HBaseConfiguration
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SCHEMA_NAME = "HBase";
    public static final String DEFAULT_ZOOKEEPER_HOSTNAME = "127.0.0.1";
    public static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    public static final int DEFAULT_HBASE_CLIENT_RETRIES = 1;
    public static final int DEFAULT_ZOOKEEPER_SESSION_TIMEOUT = 5000;
    public static final int DEFAULT_ZOOKEEPER_RECOVERY_RETRIES = 1;
    private final String _schemaName;
    private final int _zookeeperPort;
    private final String _zookeeperHostname;
    private final SimpleTableDef[] _tableDefinitions;
    private final ColumnType _defaultRowKeyType;
    private final int _hbaseClientRetries;
    private final int _zookeeperSessionTimeout;
    private final int _zookeeperRecoveryRetries;

    public HBaseConfiguration() {
        this(DEFAULT_ZOOKEEPER_HOSTNAME, 2181);
    }

    public HBaseConfiguration(String zookeeperHostname, int zookeeperPort) {
        this(DEFAULT_SCHEMA_NAME, zookeeperHostname, zookeeperPort, null, ColumnType.BINARY);
    }

    public HBaseConfiguration(String zookeeperHostname, int zookeeperPort, ColumnType defaultRowKeyType) {
        this(DEFAULT_SCHEMA_NAME, zookeeperHostname, zookeeperPort, null, defaultRowKeyType);
    }

    public HBaseConfiguration(String schemaName, String zookeeperHostname, int zookeeperPort, SimpleTableDef[] tableDefinitions, ColumnType defaultRowKeyType) {
        this(schemaName, zookeeperHostname, zookeeperPort, tableDefinitions, defaultRowKeyType, 1, 5000, 1);
    }

    public HBaseConfiguration(String schemaName, String zookeeperHostname, int zookeeperPort, SimpleTableDef[] tableDefinitions, ColumnType defaultRowKeyType, int hbaseClientRetries, int zookeeperSessionTimeout, int zookeeperRecoveryRetries) {
        this._schemaName = schemaName;
        this._zookeeperHostname = zookeeperHostname;
        this._zookeeperPort = zookeeperPort;
        this._tableDefinitions = tableDefinitions;
        this._defaultRowKeyType = defaultRowKeyType;
        this._hbaseClientRetries = hbaseClientRetries;
        this._zookeeperSessionTimeout = zookeeperSessionTimeout;
        this._zookeeperRecoveryRetries = zookeeperRecoveryRetries;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getZookeeperHostname() {
        return this._zookeeperHostname;
    }

    public int getZookeeperPort() {
        return this._zookeeperPort;
    }

    public SimpleTableDef[] getTableDefinitions() {
        return this._tableDefinitions;
    }

    public ColumnType getDefaultRowKeyType() {
        return this._defaultRowKeyType;
    }

    protected void decorateIdentity(List<Object> list) {
        list.add(this._schemaName);
        list.add(this._zookeeperHostname);
        list.add(this._zookeeperPort);
        list.add(this._tableDefinitions);
        list.add(this._defaultRowKeyType);
    }

    public int getHBaseClientRetries() {
        return this._hbaseClientRetries;
    }

    public int getZookeeperSessionTimeout() {
        return this._zookeeperSessionTimeout;
    }

    public int getZookeeperRecoveryRetries() {
        return this._zookeeperRecoveryRetries;
    }
}

