/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.fixedwidth.FixedWidthColumnSpec;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedWidthConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(FixedWidthConfigurationReader.class);
    private final Pattern PATTERN_SAS_INPUT_LINE = Pattern.compile("\\@(\\d+) (.+) .*?(\\d+)\\.");
    private final Pattern PATTERN_SAS_LABEL_LINE = Pattern.compile("(.+) \\\"(.+)\\\"");

    public FixedWidthConfiguration readFromSasFormatFile(String encoding, Resource resource, boolean failOnInconsistentLineWidth) {
        ArrayList<FixedWidthColumnSpec> columnSpecs = new ArrayList<FixedWidthColumnSpec>();
        CsvDataContext dataContext = new CsvDataContext(resource, new CsvConfiguration());
        Table table = dataContext.getDefaultSchema().getTable(0);
        try (DataSet dataSet = dataContext.query().from(table).select(new String[]{"Name", "BeginPosition", "EndPosition"}).execute();){
            while (dataSet.next()) {
                String name = (String)dataSet.getRow().getValue(0);
                int beginPosition = Integer.parseInt((String)dataSet.getRow().getValue(1));
                int endPosition = Integer.parseInt((String)dataSet.getRow().getValue(2));
                int width = 1 + endPosition - beginPosition;
                columnSpecs.add(new FixedWidthColumnSpec(name, width));
            }
        }
        return new FixedWidthConfiguration(encoding, columnSpecs, failOnInconsistentLineWidth);
    }

    public FixedWidthConfiguration readFromSasInputDefinition(String encoding, Resource resource, boolean failOnInconsistentLineWidth) {
        final LinkedHashMap inputWidthDeclarations = new LinkedHashMap();
        final HashMap labelDeclarations = new HashMap();
        resource.read((Action)new Action<InputStream>(){
            private boolean inInputSection = false;
            private boolean inLabelSection = false;

            public void run(InputStream in) throws Exception {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String line = reader.readLine();
                    while (line != null) {
                        this.processLine(line);
                        line = reader.readLine();
                    }
                }
            }

            private void processLine(String line) {
                if ((line = line.trim()).isEmpty()) {
                    return;
                }
                if (";".equals(line)) {
                    this.inInputSection = false;
                    this.inLabelSection = false;
                    return;
                }
                if ("INPUT".equals(line)) {
                    this.inInputSection = true;
                    return;
                }
                if ("LABEL".equals(line)) {
                    this.inLabelSection = true;
                    return;
                }
                if (this.inInputSection) {
                    Matcher matcher = FixedWidthConfigurationReader.this.PATTERN_SAS_INPUT_LINE.matcher(line);
                    if (matcher.matches()) {
                        String positionSpec = matcher.group(1);
                        String nameSpec = matcher.group(2);
                        int width = Integer.parseInt(matcher.group(3));
                        logger.debug("Parsed INPUT line \"{}\": position={}, name={}, width={}", new Object[]{line, positionSpec, nameSpec, width});
                        inputWidthDeclarations.put(nameSpec, width);
                    } else {
                        logger.debug("Failed to parse/recognize INPUT line \"{}\"", (Object)line);
                    }
                } else if (this.inLabelSection) {
                    Matcher matcher = FixedWidthConfigurationReader.this.PATTERN_SAS_LABEL_LINE.matcher(line);
                    if (matcher.matches()) {
                        String nameSpec = matcher.group(1);
                        String labelSpec = matcher.group(2);
                        logger.debug("Parsed LABEL line \"{}\": name={}, label={}", new Object[]{line, nameSpec, labelSpec});
                        labelDeclarations.put(nameSpec, labelSpec);
                    } else {
                        logger.debug("Failed to parse/recognize LABEL line \"{}\"", (Object)line);
                    }
                }
                if (line.endsWith(";")) {
                    this.inInputSection = false;
                    this.inLabelSection = false;
                }
            }
        });
        ArrayList<FixedWidthColumnSpec> columnSpecs = new ArrayList<FixedWidthColumnSpec>();
        for (Map.Entry entry : inputWidthDeclarations.entrySet()) {
            String columnKey = (String)entry.getKey();
            Integer columnWidth = (Integer)entry.getValue();
            String columnLabel = (String)labelDeclarations.get(columnKey);
            String columnName = columnLabel == null ? columnKey : columnLabel;
            columnSpecs.add(new FixedWidthColumnSpec(columnName, columnWidth));
        }
        return new FixedWidthConfiguration(encoding, columnSpecs, failOnInconsistentLineWidth);
    }
}

