/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.fixedwidth.FixedWidthReader;
import org.apache.metamodel.fixedwidth.InconsistentValueWidthException;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.FileHelper;

class FixedWidthDataSet
extends AbstractDataSet {
    private final FixedWidthReader _reader;
    private volatile Integer _rowsRemaining;
    private volatile Row _row;

    public FixedWidthDataSet(FixedWidthReader reader, List<Column> columns, Integer maxRows) {
        super(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        this._reader = reader;
        this._rowsRemaining = maxRows;
    }

    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._reader});
        this._row = null;
        this._rowsRemaining = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Row getRow() {
        return this._row;
    }

    public boolean next() {
        if (this._rowsRemaining != null && this._rowsRemaining > 0) {
            Integer n = this._rowsRemaining;
            Integer n2 = this._rowsRemaining = Integer.valueOf(this._rowsRemaining - 1);
            return this.nextInternal();
        }
        if (this._rowsRemaining == null) {
            return this.nextInternal();
        }
        return false;
    }

    private boolean nextInternal() {
        InconsistentValueWidthException exception;
        String[] stringValues;
        if (this._reader == null) {
            return false;
        }
        try {
            stringValues = this._reader.readLine();
            exception = null;
        }
        catch (InconsistentValueWidthException e) {
            stringValues = e.getSourceResult();
            exception = e;
        }
        if (stringValues == null) {
            this.close();
            return false;
        }
        int size = this.getHeader().size();
        Object[] rowValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            Column column = this.getHeader().getSelectItem(i).getColumn();
            int columnNumber = column.getColumnNumber();
            rowValues[i] = columnNumber < stringValues.length ? stringValues[columnNumber] : null;
        }
        this._row = new DefaultRow(this.getHeader(), rowValues);
        if (exception != null) {
            throw new InconsistentValueWidthException(this._row, exception);
        }
        return true;
    }
}

