/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.ArrayList;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.elasticsearch.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.ElasticSearchUpdateCallback;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchCreateTableBuilder
extends AbstractTableCreationBuilder<ElasticSearchUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchCreateTableBuilder.class);

    public ElasticSearchCreateTableBuilder(ElasticSearchUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        if (table.getColumnByName("_id") == null) {
            MutableColumn idColumn = new MutableColumn("_id", ColumnType.STRING).setTable((Table)table).setPrimaryKey(true);
            table.addColumn(0, (Column)idColumn);
        }
        ElasticSearchDataContext dataContext = ((ElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        IndicesAdminClient indicesAdmin = dataContext.getElasticSearchClient().admin().indices();
        String indexName = dataContext.getIndexName();
        ArrayList<String> sourceProperties = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            String columnName = column.getName();
            if ("_id".equals(columnName)) continue;
            sourceProperties.add(columnName);
            String type = this.getType(column);
            if (type == null) {
                sourceProperties.add("store=true");
                continue;
            }
            sourceProperties.add("type=" + type + ",store=true");
        }
        PutMappingRequestBuilder requestBuilder = new PutMappingRequestBuilder(indicesAdmin).setIndices(new String[]{indexName}).setType(table.getName());
        requestBuilder.setSource(sourceProperties.toArray());
        PutMappingResponse result = (PutMappingResponse)requestBuilder.execute().actionGet();
        logger.debug("PutMapping response: acknowledged={}", (Object)result.isAcknowledged());
        MutableSchema schema = (MutableSchema)this.getSchema();
        schema.addTable(table);
        return table;
    }

    private String getType(Column column) {
        String nativeType = column.getNativeType();
        if (!Strings.isNullOrEmpty((String)nativeType)) {
            return nativeType;
        }
        ColumnType type = column.getType();
        if (type == null) {
            throw new IllegalStateException("No column type specified for '" + column.getName() + "' - cannot build ElasticSearch mapping without type.");
        }
        if (type.isLiteral()) {
            return "string";
        }
        if (type == ColumnType.FLOAT) {
            return "float";
        }
        if (type == ColumnType.DOUBLE || type == ColumnType.NUMERIC || type == ColumnType.NUMBER) {
            return "double";
        }
        if (type == ColumnType.SMALLINT) {
            return "short";
        }
        if (type == ColumnType.TINYINT) {
            return "byte";
        }
        if (type == ColumnType.INTEGER) {
            return "integer";
        }
        if (type == ColumnType.DATE || type == ColumnType.TIMESTAMP) {
            return "date";
        }
        if (type == ColumnType.BINARY || type == ColumnType.VARBINARY) {
            return "binary";
        }
        if (type == ColumnType.BOOLEAN || type == ColumnType.BIT) {
            return "boolean";
        }
        if (type == ColumnType.MAP) {
            return "object";
        }
        throw new UnsupportedOperationException("Unsupported column type '" + type.getName() + "' of column '" + column.getName() + "' - cannot translate to an ElasticSearch type.");
    }
}

