/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import org.apache.metamodel.elasticsearch.ElasticSearchMetaData;
import org.apache.metamodel.schema.ColumnType;

public class ElasticSearchMetaDataParser {
    public static ElasticSearchMetaData parse(Object metaDataInfo) {
        String plainMetaDataInfo = ElasticSearchMetaDataParser.removeFirstAndLastCharacter(metaDataInfo.toString());
        String metaDataWithoutDateFormats = ElasticSearchMetaDataParser.removeDateFormats(plainMetaDataInfo);
        String[] metaDataFields = metaDataWithoutDateFormats.split(",");
        String[] fieldNames = new String[metaDataFields.length + 1];
        ColumnType[] columnTypes = new ColumnType[metaDataFields.length + 1];
        fieldNames[0] = "_id";
        columnTypes[0] = ColumnType.STRING;
        int i = 1;
        for (String metaDataField : metaDataFields) {
            fieldNames[i] = ElasticSearchMetaDataParser.getNameFromMetaDataField(metaDataField);
            columnTypes[i] = ElasticSearchMetaDataParser.getColumnTypeFromMetaDataField(metaDataField);
            ++i;
        }
        return new ElasticSearchMetaData(fieldNames, columnTypes);
    }

    private static String removeFirstAndLastCharacter(String metaDataInfo) {
        return metaDataInfo.substring(1, metaDataInfo.length() - 1);
    }

    private static String removeDateFormats(String metaDataInfo) {
        return metaDataInfo.replaceAll("type=date.*?}", "type=date}");
    }

    private static String getNameFromMetaDataField(String metaDataField) {
        return metaDataField.substring(0, metaDataField.indexOf("=")).trim();
    }

    private static ColumnType getColumnTypeFromMetaDataField(String metaDataField) {
        String metaDataFieldType = ElasticSearchMetaDataParser.getMetaDataFieldTypeFromMetaDataField(metaDataField);
        ColumnType columnType = metaDataFieldType.equals("long") ? ColumnType.BIGINT : (metaDataFieldType.equals("date") ? ColumnType.DATE : (metaDataFieldType.equals("string") ? ColumnType.STRING : (metaDataFieldType.equals("float") ? ColumnType.FLOAT : (metaDataFieldType.equals("boolean") ? ColumnType.BOOLEAN : (metaDataFieldType.equals("double") ? ColumnType.DOUBLE : ColumnType.STRING)))));
        return columnType;
    }

    private static String getMetaDataFieldTypeFromMetaDataField(String metaDataField) {
        String metaDataFieldWithoutName = metaDataField.substring(metaDataField.indexOf("=") + 1);
        String metaDataFieldType = metaDataFieldWithoutName.substring(metaDataFieldWithoutName.indexOf("=") + 1, metaDataFieldWithoutName.length() - 1);
        return metaDataFieldType;
    }
}

