/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.ElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.ElasticSearchUtils;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectLookupContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataContext
extends QueryPostprocessDataContext
implements DataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataContext.class);
    public static final String FIELD_ID = "_id";
    public static final TimeValue TIMEOUT_SCROLL = TimeValue.timeValueSeconds((long)60L);
    private final Client elasticSearchClient;
    private final SimpleTableDef[] tableDefs;
    private final String indexName;

    public ElasticSearchDataContext(Client client, String indexName, SimpleTableDef ... tableDefs) {
        this.elasticSearchClient = client;
        this.indexName = indexName;
        this.tableDefs = tableDefs;
    }

    public ElasticSearchDataContext(Client client, String indexName) {
        this(client, indexName, ElasticSearchDataContext.detectSchema(client, indexName));
    }

    public static SimpleTableDef[] detectSchema(Client client, String indexName) {
        ClusterStateRequestBuilder clusterStateRequestBuilder = client.admin().cluster().prepareState();
        try {
            Method method;
            byte majorVersion = Version.CURRENT.major;
            String[] methodArgument = new String[]{indexName};
            if (majorVersion == 0) {
                method = ClusterStateRequestBuilder.class.getMethod("setFilterIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            } else {
                method = ClusterStateRequestBuilder.class.getMethod("setIndices", String[].class);
                method.invoke((Object)clusterStateRequestBuilder, new Object[]{methodArgument});
            }
        }
        catch (Exception e) {
            logger.error("Failed to set index name on ClusterStateRequestBuilder, version {}", (Object)Version.CURRENT, (Object)e);
            throw new MetaModelException("Failed to create request for index information needed to detect schema", e);
        }
        ClusterState cs = ((ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet()).getState();
        IndexMetaData imd = cs.getMetaData().index(indexName);
        ImmutableOpenMap mappings = imd.getMappings();
        ObjectLookupContainer documentTypes = mappings.keys();
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        for (ObjectCursor documentTypeCursor : documentTypes) {
            String documentType = documentTypeCursor.value.toString();
            try {
                SimpleTableDef table = ElasticSearchDataContext.detectTable(cs, indexName, documentType);
                result.add(table);
            }
            catch (Exception e) {
                logger.error("Unexpected error during detectTable for document type: {}", (Object)documentType, (Object)e);
            }
        }
        SimpleTableDef[] tableDefArray = result.toArray(new SimpleTableDef[result.size()]);
        Arrays.sort(tableDefArray, new Comparator<SimpleTableDef>(){

            @Override
            public int compare(SimpleTableDef o1, SimpleTableDef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tableDefArray;
    }

    public static SimpleTableDef detectTable(ClusterState cs, String indexName, String documentType) throws Exception {
        IndexMetaData imd = cs.getMetaData().index(indexName);
        MappingMetaData mappingMetaData = imd.mapping(documentType);
        Map mp = mappingMetaData.getSourceAsMap();
        Iterator it = mp.entrySet().iterator();
        Map.Entry pair = it.next();
        ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse(pair.getValue());
        return new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this.tableDefs) {
            MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
            Column idColumn = table.getColumnByName(FIELD_ID);
            if (idColumn != null && idColumn instanceof MutableColumn) {
                MutableColumn mutableColumn = (MutableColumn)idColumn;
                mutableColumn.setPrimaryKey(true);
            }
            theSchema.addTable(table);
        }
        return theSchema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.indexName;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        String documentType = table.getName();
        SearchRequestBuilder requestBuilder = this.elasticSearchClient.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{documentType});
        if (this.limitMaxRowsIsSet(maxRows)) {
            requestBuilder.setSize(maxRows);
        } else {
            requestBuilder.setScroll(TIMEOUT_SCROLL);
        }
        SearchResponse response = (SearchResponse)requestBuilder.execute().actionGet();
        return new ElasticSearchDataSet(this.elasticSearchClient, response, columns, false);
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        String id;
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        GetResponse response = (GetResponse)this.elasticSearchClient.prepareGet(this.indexName, documentType, id = keyValue.toString()).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        Map source = response.getSource();
        String documentId = response.getId();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return ElasticSearchUtils.createRow(source, documentId, (DataSetHeader)header);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        CountResponse response = (CountResponse)this.elasticSearchClient.prepareCount(new String[]{this.indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType)).execute().actionGet();
        return response.getCount();
    }

    private boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }
}

