/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.BatchUpdateScript;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.AbstractElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestClient;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataSet;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestDataContext
extends AbstractElasticSearchDataContext {
    public static final String DEFAULT_TABLE_NAME = "_doc";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestDataContext.class);
    private static final int SCROLL_THRESHOLD = 400;
    private final RestHighLevelClient restHighLevelClient;

    public ElasticSearchRestDataContext(RestHighLevelClient client, String indexName, SimpleTableDef ... tableDefinitions) {
        super(indexName, tableDefinitions);
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        this.restHighLevelClient = client;
        this.dynamicTableDefinitions.addAll(Arrays.asList(this.detectSchema()));
    }

    public ElasticSearchRestDataContext(RestHighLevelClient client, String indexName) {
        this(client, indexName, new SimpleTableDef[0]);
    }

    protected SimpleTableDef[] detectSchema() {
        Map mappings;
        logger.info("Detecting schema for index '{}'", (Object)this.indexName);
        try {
            mappings = this.getRestHighLevelClient().indices().getMapping(new GetMappingsRequest().indices(new String[]{this.indexName}), RequestOptions.DEFAULT).mappings();
        }
        catch (IOException e) {
            logger.error("Failed to retrieve mappings", (Throwable)e);
            throw new MetaModelException("Failed to execute request for index information needed to detect schema", (Exception)e);
        }
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        if (mappings.isEmpty()) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.", (Object)this.indexName);
        } else {
            for (Map.Entry mapping : mappings.entrySet()) {
                String tableName = ((MappingMetaData)mapping.getValue()).type();
                Map mappingConfiguration = ((MappingMetaData)mapping.getValue()).getSourceAsMap();
                Map properties = (Map)mappingConfiguration.get("properties");
                if (properties == null) continue;
                try {
                    SimpleTableDef table = ElasticSearchRestDataContext.detectTable(properties, tableName);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document mapping type '{}'", (Object)tableName, (Object)e);
                }
            }
        }
        return ElasticSearchRestDataContext.sortTables(result);
    }

    protected void onSchemaCacheRefreshed() {
        try {
            this.getRestHighLevelClient().indices().refresh(new RefreshRequest(new String[]{this.indexName}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.info("Failed to refresh index \"{}\"", (Object)this.indexName, (Object)e);
        }
        this.detectSchema();
    }

    private static SimpleTableDef detectTable(Map<String, Object> metadataProperties, String tableName) {
        ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse(metadataProperties);
        return new SimpleTableDef(tableName, metaData.getColumnNames(), metaData.getColumnTypes());
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchSourceBuilder searchSourceBuilder = this.createSearchRequest(firstRow, maxRows, queryBuilder);
            SearchResponse result = this.executeSearch(table, searchSourceBuilder, this.scrollNeeded(maxRows));
            return new ElasticSearchRestDataSet(this.getRestHighLevelClient(), result, selectItems);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    private boolean scrollNeeded(int maxRows) {
        return !this.limitMaxRowsIsSet(maxRows) || maxRows > 400;
    }

    private SearchResponse executeSearch(Table table, SearchSourceBuilder searchSourceBuilder, boolean scroll) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName()}, searchSourceBuilder);
        if (scroll) {
            searchRequest.scroll(TIMEOUT_SCROLL);
        }
        try {
            return this.getRestHighLevelClient().search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.warn("Could not execute ElasticSearch query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch query", (Exception)e);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        SearchResponse searchResult = this.executeSearch(table, this.createSearchRequest(1, maxRows, null), this.scrollNeeded(maxRows));
        return new ElasticSearchRestDataSet(this.getRestHighLevelClient(), searchResult, columns.stream().map(SelectItem::new).collect(Collectors.toList()));
    }

    private SearchSourceBuilder createSearchRequest(int firstRow, int maxRows, QueryBuilder queryBuilder) {
        SearchSourceBuilder searchRequest = new SearchSourceBuilder();
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.from(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.size(maxRows);
        } else {
            searchRequest.size(400);
        }
        if (queryBuilder != null) {
            searchRequest.query(queryBuilder);
        }
        return searchRequest;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        if (keyValue == null) {
            return null;
        }
        String id = keyValue.toString();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        try {
            Map source = this.getRestHighLevelClient().get(new GetRequest(this.getIndexName(), id), RequestOptions.DEFAULT).getSource();
            if (source == null) {
                return null;
            }
            return ElasticSearchUtils.createRow((Map)source, (String)id, (DataSetHeader)header);
        }
        catch (IOException e) {
            logger.warn("Could not execute ElasticSearch query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch query", (Exception)e);
        }
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType));
        sourceBuilder.size(0);
        try {
            return this.getRestHighLevelClient().search((SearchRequest)new SearchRequest((String[])new String[]{this.getIndexName()}, (SearchSourceBuilder)sourceBuilder), (RequestOptions)RequestOptions.DEFAULT).getHits().getTotalHits().value;
        }
        catch (Exception e) {
            logger.warn("Could not execute ElasticSearch get query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch get query", e);
        }
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        boolean isBatch = update instanceof BatchUpdateScript;
        ElasticSearchRestUpdateCallback callback = new ElasticSearchRestUpdateCallback(this, isBatch);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
        return callback.getUpdateSummary();
    }

    @Deprecated
    public ElasticSearchRestClient getElasticSearchClient() {
        return new ElasticSearchRestClient(this.getRestHighLevelClient().getLowLevelClient());
    }

    RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }
}

