/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchRestCreateTableBuilder
extends AbstractTableCreationBuilder<ElasticSearchRestUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestCreateTableBuilder.class);

    public ElasticSearchRestCreateTableBuilder(ElasticSearchRestUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() {
        MutableTable table = this.getTable();
        Map source = ElasticSearchUtils.getMappingSource((MutableTable)table);
        ElasticSearchRestDataContext dataContext = ((ElasticSearchRestUpdateCallback)this.getUpdateCallback()).getDataContext();
        String indexName = dataContext.getIndexName();
        List tables = dataContext.getDefaultSchema().getTables();
        if (!tables.isEmpty() && !((Table)tables.get(0)).getName().equals(table.getName())) {
            throw new MetaModelException("Can't add more than one table to Elasticsearch index.");
        }
        try {
            dataContext.getRestHighLevelClient().indices().putMapping(new PutMappingRequest(new String[]{indexName}).source(source), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.warn("Could not update mappings.", (Throwable)e);
            throw new MetaModelException("Could not update mappings.", (Exception)e);
        }
        MutableSchema schema = (MutableSchema)this.getSchema();
        schema.addTable((Table)table);
        return table;
    }
}

