/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.core.Index;
import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

final class JestElasticSearchInsertBuilder
extends AbstractRowInsertionBuilder<JestElasticSearchUpdateCallback> {
    public JestElasticSearchInsertBuilder(JestElasticSearchUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        JestElasticSearchUpdateCallback updateCallback = (JestElasticSearchUpdateCallback)this.getUpdateCallback();
        ElasticSearchRestDataContext dataContext = updateCallback.getDataContext();
        String indexName = dataContext.getIndexName();
        String documentType = this.getTable().getName();
        HashMap<String, Object> source = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        String id = null;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String columnName = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(columnName)) {
                if (value == null) continue;
                id = value.toString();
                continue;
            }
            String fieldName = ElasticSearchUtils.getValidatedFieldName((String)columnName);
            source.put(fieldName, value);
        }
        assert (!source.isEmpty());
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(source).index(indexName)).type(documentType)).id(id)).setParameter("op_type", (Object)"create")).build();
        ((JestElasticSearchUpdateCallback)this.getUpdateCallback()).execute((Action<?>)index);
    }
}

