/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.indices.mapping.PutMapping;
import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class JestElasticSearchCreateTableBuilder
extends AbstractTableCreationBuilder<JestElasticSearchUpdateCallback> {
    public JestElasticSearchCreateTableBuilder(JestElasticSearchUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        Map source = ElasticSearchUtils.getMappingSource((MutableTable)table);
        ElasticSearchRestDataContext dataContext = ((JestElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        String indexName = dataContext.getIndexName();
        PutMapping putMapping = new PutMapping.Builder(indexName, table.getName(), (Object)source).build();
        ((JestElasticSearchUpdateCallback)this.getUpdateCallback()).execute((Action<?>)putMapping);
        MutableSchema schema = (MutableSchema)this.getSchema();
        schema.addTable((Table)table);
        return table;
    }
}

