/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.indices.mapping.DeleteMapping;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.drop.AbstractTableDropBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JestElasticSearchDropTableBuilder
extends AbstractTableDropBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JestElasticSearchDropTableBuilder.class);
    private final JestElasticSearchUpdateCallback _updateCallback;

    public JestElasticSearchDropTableBuilder(JestElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        ElasticSearchRestDataContext dataContext = this._updateCallback.getDataContext();
        Table table = this.getTable();
        String documentType = table.getName();
        logger.info("Deleting mapping / document type: {}", (Object)documentType);
        DeleteMapping deleteIndex = new DeleteMapping.Builder(dataContext.getIndexName(), documentType).build();
        this._updateCallback.execute((Action<?>)deleteIndex);
        MutableSchema schema = (MutableSchema)table.getSchema();
        schema.removeTable(table);
    }
}

