/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import java.io.IOException;
import org.apache.metamodel.MetaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JestClientExecutor {
    private static final Logger logger = LoggerFactory.getLogger(JestClientExecutor.class);

    JestClientExecutor() {
    }

    static <T extends JestResult> T execute(JestClient jestClient, Action<T> clientRequest) {
        return JestClientExecutor.execute(jestClient, clientRequest, true);
    }

    static <T extends JestResult> T execute(JestClient jestClient, Action<T> clientRequest, boolean doThrow) {
        try {
            JestResult result = jestClient.execute(clientRequest);
            logger.debug("{} response: acknowledged={}", clientRequest, (Object)result.isSucceeded());
            return (T)result;
        }
        catch (IOException e) {
            logger.warn("Could not execute command {} ", clientRequest, (Object)e);
            if (doThrow) {
                throw new MetaModelException("Could not execute command " + clientRequest, (Exception)e);
            }
            return null;
        }
    }
}

