/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JestElasticSearchInsertBuilder
extends AbstractRowInsertionBuilder<JestElasticSearchUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(JestElasticSearchInsertBuilder.class);

    public JestElasticSearchInsertBuilder(JestElasticSearchUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        ElasticSearchRestDataContext dataContext = ((JestElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        String indexName = dataContext.getIndexName();
        String documentType = this.getTable().getName();
        HashMap<String, Object> source = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        String id = null;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String name = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(name)) {
                if (value == null) continue;
                id = value.toString();
                continue;
            }
            source.put(name, value);
        }
        assert (!source.isEmpty());
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(source).index(indexName)).type(documentType)).id(id)).setParameter("op_type", (Object)"create")).build();
        DocumentResult result = (DocumentResult)JestClientExecutor.execute(dataContext.getElasticSearchClient(), index);
        logger.debug("Inserted document: id={}", (Object)result.getId());
    }
}

