/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.core.DeleteByQuery;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

final class JestElasticSearchDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final JestElasticSearchUpdateCallback _updateCallback;

    public JestElasticSearchDeleteBuilder(JestElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        Table table = this.getTable();
        String documentType = table.getName();
        ElasticSearchRestDataContext dataContext = this._updateCallback.getDataContext();
        String indexName = dataContext.getIndexName();
        List whereItems = this.getWhereItems();
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere((List)whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder == null) {
            throw new UnsupportedOperationException("Could not push down WHERE items to delete by query request: " + whereItems);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        DeleteByQuery deleteByQuery = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(searchSourceBuilder.toString()).addIndex(indexName)).addType(documentType)).build();
        JestClientExecutor.execute(dataContext.getElasticSearchClient(), deleteByQuery);
    }
}

