/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.util.HashMap;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.AbstractRowUpdationBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ElasticSearchUpdateBuilder
extends AbstractRowUpdationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchUpdateBuilder.class);
    private final ElasticSearchUpdateCallback _updateCallback;

    public ElasticSearchUpdateBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        Table table = this.getTable();
        String documentType = table.getName();
        ElasticSearchDataContext dataContext = this._updateCallback.getDataContext();
        Client client = dataContext.getElasticSearchClient();
        String indexName = dataContext.getIndexName();
        List whereItems = this.getWhereItems();
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere((List)whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder == null) {
            throw new UnsupportedOperationException("Could not push down WHERE items to delete by query request: " + whereItems);
        }
        SearchResponse response = (SearchResponse)client.prepareSearch(new String[]{indexName}).setQuery(queryBuilder).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            String typeId = hit.getId();
            UpdateRequestBuilder requestBuilder = ((UpdateRequestBuilder)new UpdateRequestBuilder((ElasticsearchClient)client, UpdateAction.INSTANCE).setIndex(indexName)).setType(documentType).setId(typeId);
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            Column[] columns = this.getColumns();
            Object[] values = this.getValues();
            for (int i = 0; i < columns.length; ++i) {
                if (!this.isSet(columns[i])) continue;
                String name = columns[i].getName();
                Object value = values[i];
                if ("_id".equals(name)) {
                    if (value == null) continue;
                    requestBuilder.setId(value.toString());
                    continue;
                }
                valueMap.put(name, value);
            }
            assert (!valueMap.isEmpty());
            requestBuilder.setDoc(valueMap);
            UpdateResponse updateResponse = (UpdateResponse)requestBuilder.execute().actionGet();
            logger.debug("Update document: id={}", (Object)updateResponse.getId());
            client.admin().indices().prepareRefresh(new String[]{indexName}).get();
        }
    }
}

