/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class ElasticSearchDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDeleteBuilder.class);
    private final ElasticSearchUpdateCallback _updateCallback;

    public ElasticSearchDeleteBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        Table table = this.getTable();
        String documentType = table.getName();
        ElasticSearchDataContext dataContext = this._updateCallback.getDataContext();
        Client client = dataContext.getElasticSearchClient();
        String indexName = dataContext.getIndexName();
        List whereItems = this.getWhereItems();
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere((List)whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder == null) {
            throw new UnsupportedOperationException("Could not push down WHERE items to delete by query request: " + whereItems);
        }
        SearchResponse response = (SearchResponse)client.prepareSearch(new String[]{indexName}).setQuery(queryBuilder).setTypes(new String[]{documentType}).execute().actionGet();
        client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            String typeId = hit.getId();
            DeleteResponse deleteResponse = (DeleteResponse)((DeleteRequestBuilder)client.prepareDelete().setIndex(indexName)).setType(documentType).setId(typeId).execute().actionGet();
            logger.debug("Deleted documents by query." + deleteResponse.getResult());
        }
        client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
    }
}

